unit HTMLEditFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, SynEditHighlighter,
  SynHighlighterHtml, SynEdit, SynMemo, RzButton, Htmlview, SynEditKeyCmds,
  Mask, RzEdit, RzPanel, RzRadChk;

type
  THTMLEditForm = class(TForm)
    HTMLMemo: TSynMemo;
    SynHTMLSyn1: TSynHTMLSyn;
    Panel1: TPanel;
    Panel2: TPanel;
    OpenDialog: TOpenDialog;
    Label2: TLabel;
    Panel3: TPanel;
    Label3: TLabel;
    HTMLPreview: ThtmlViewer;
    Label1: TLabel;
    btnNew: TRzBitBtn;
    btnBold: TRzBitBtn;
    btnItalic: TRzBitBtn;
    btnUnderline: TRzBitBtn;
    btnLeft: TRzBitBtn;
    btnCenter: TRzBitBtn;
    btnRight: TRzBitBtn;
    btnBR: TRzBitBtn;
    Label4: TLabel;
    RzGroupBox3: TRzGroupBox;
    LinkText: TRzEdit;
    LinkURL: TRzEdit;
    btnAddLink: TRzButton;
    chkUnderlined: TRzCheckBox;
    btnSave: TRzBitBtn;
    btnLoad: TRzBitBtn;
    btnCancel: TRzBitBtn;
    procedure btnLoadClick(Sender: TObject);
    procedure HTMLMemoChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure HTMLMemoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnNewClick(Sender: TObject);
    procedure btnBRClick(Sender: TObject);
    procedure btnBoldClick(Sender: TObject);
    procedure btnItalicClick(Sender: TObject);
    procedure btnUnderlineClick(Sender: TObject);
    procedure btnLeftClick(Sender: TObject);
    procedure btnCenterClick(Sender: TObject);
    procedure btnRightClick(Sender: TObject);
    procedure btnAddLinkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    IsHTML: Boolean;
    FileName: String;
  end;

var
  HTMLEditForm: THTMLEditForm;

implementation

{$R *.dfm}

procedure THTMLEditForm.btnLoadClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    HTMLMemo.Lines.LoadFromFile(OpenDialog.Filename);
    HTMLMemoChange(Self);
  end;
end;

procedure THTMLEditForm.HTMLMemoChange(Sender: TObject);
begin
  HTMLPreview.LoadFromString(HTMLMemo.Lines.Text, '');
  HTMLMemo.SetFocus;
end;

procedure THTMLEditForm.FormResize(Sender: TObject);
begin
  HTMLPreview.Width := Width - 25;
end;

procedure THTMLEditForm.HTMLMemoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  HTMLPreview.LoadFromString(HTMLMemo.Lines.Text, '');
  HTMLMemo.SetFocus;
end;

procedure THTMLEditForm.btnNewClick(Sender: TObject);
begin
  HTMLMemo.Lines.Clear;
  HTMLMemoChange(Self);
end;

procedure THTMLEditForm.btnBRClick(Sender: TObject);
const InsertString = '<br>';
var I: Integer;
begin
  HTMLMemo.BeginUndoBlock;
  for I:=1 to Length(InsertString) do
    HTMLMemo.CommandProcessor(ecChar, InsertString[I], nil);
  HTMLMemo.EndUndoBlock;
end;

procedure THTMLEditForm.btnBoldClick(Sender: TObject);
const A = '<b>';
      B = '</b>';
var I: Integer;
begin
  if not HTMLMemo.SelAvail then
  begin
    HTMLMemo.BeginUndoBlock;
    for I:=1 to Length(A) do
      HTMLMemo.CommandProcessor(ecChar, A[I], nil);
    for I:=1 to Length(B) do
      HTMLMemo.CommandProcessor(ecChar, B[I], nil);
    HTMLMemo.EndUndoBlock;
  end
  else
  begin
    HTMLMemo.BeginUndoBlock;
    HTMLMemo.SelText := '<b>'+HTMLMemo.SelText+'</b>';
    HTMLMemo.EndUndoBlock;
  end;
end;

procedure THTMLEditForm.btnItalicClick(Sender: TObject);
const A = '<i>';
      B = '</i>';
var I: Integer;
begin
  if not HTMLMemo.SelAvail then
  begin
    HTMLMemo.BeginUndoBlock;
    for I:=1 to Length(A) do
      HTMLMemo.CommandProcessor(ecChar, A[I], nil);
    for I:=1 to Length(B) do
      HTMLMemo.CommandProcessor(ecChar, B[I], nil);
    HTMLMemo.EndUndoBlock;
  end
  else
  begin
    HTMLMemo.BeginUndoBlock;
    HTMLMemo.SelText := '<i>'+HTMLMemo.SelText+'</i>';
    HTMLMemo.EndUndoBlock;
  end;
end;

procedure THTMLEditForm.btnUnderlineClick(Sender: TObject);
const A = '<u>';
      B = '</u>';
var I: Integer;
begin
  if not HTMLMemo.SelAvail then
  begin
    HTMLMemo.BeginUndoBlock;
    for I:=1 to Length(A) do
      HTMLMemo.CommandProcessor(ecChar, A[I], nil);
    for I:=1 to Length(B) do
      HTMLMemo.CommandProcessor(ecChar, B[I], nil);
    HTMLMemo.EndUndoBlock;
  end
  else
  begin
    HTMLMemo.BeginUndoBlock;
    HTMLMemo.SelText := '<u>'+HTMLMemo.SelText+'</u>';
    HTMLMemo.EndUndoBlock;
  end;
end;

procedure THTMLEditForm.btnLeftClick(Sender: TObject);
const A = '<DIV ALIGN=left>';
      B = '</DIV>';
var I: Integer;
begin
  if not HTMLMemo.SelAvail then
  begin
    HTMLMemo.BeginUndoBlock;
    for I:=1 to Length(A) do
      HTMLMemo.CommandProcessor(ecChar, A[I], nil);
    for I:=1 to Length(B) do
      HTMLMemo.CommandProcessor(ecChar, B[I], nil);
    HTMLMemo.EndUndoBlock;
  end
  else
  begin
    HTMLMemo.BeginUndoBlock;
    HTMLMemo.SelText := '<DIV ALIGN=left>'+HTMLMemo.SelText+'</DIV>';
    HTMLMemo.EndUndoBlock;
  end;
end;

procedure THTMLEditForm.btnCenterClick(Sender: TObject);
const A = '<CENTER>';
      B = '</CENTER>';
var I: Integer;
begin
  if not HTMLMemo.SelAvail then
  begin
    HTMLMemo.BeginUndoBlock;
    for I:=1 to Length(A) do
      HTMLMemo.CommandProcessor(ecChar, A[I], nil);
    for I:=1 to Length(B) do
      HTMLMemo.CommandProcessor(ecChar, B[I], nil);
    HTMLMemo.EndUndoBlock;
  end
  else
  begin
    HTMLMemo.BeginUndoBlock;
    HTMLMemo.SelText := '<CENTER>'+HTMLMemo.SelText+'</CENTER>';
    HTMLMemo.EndUndoBlock;
  end;
end;

procedure THTMLEditForm.btnRightClick(Sender: TObject);
const A = '<DIV ALIGN=right>';
      B = '</DIV>';
var I: Integer;
begin
  if not HTMLMemo.SelAvail then
  begin
    HTMLMemo.BeginUndoBlock;
    for I:=1 to Length(A) do
      HTMLMemo.CommandProcessor(ecChar, A[I], nil);
    for I:=1 to Length(B) do
      HTMLMemo.CommandProcessor(ecChar, B[I], nil);
    HTMLMemo.EndUndoBlock;
  end
  else
  begin
    HTMLMemo.BeginUndoBlock;
    HTMLMemo.SelText := '<DIV ALIGN=right>'+HTMLMemo.SelText+'</DIV>';
    HTMLMemo.EndUndoBlock;
  end;
end;

procedure THTMLEditForm.btnAddLinkClick(Sender: TObject);
var S: String;
    I: Integer;
begin
  if chkUnderlined.Checked then
   S := '<a href="'+LinkURL.Text+'">'+LinkText.Text+'</a>'
  else
   S := '<a href="'+LinkURL.Text+'" style=text-decoration:none>'+LinkText.Text+'</a>';
  HTMLMemo.BeginUndoBlock;
  for I:=1 to Length(S) do
    HTMLMemo.CommandProcessor(ecChar, S[I], nil);
  HTMLMemo.EndUndoBlock;
end;

end.
